unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Printers;

type
  TMainForm = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    PrinterSetupDialog: TPrinterSetupDialog;
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private


  public

    procedure Drukuj(Bmp : TBitmap);
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{--------------------------------------------------------------------------------}
procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
   Close();
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
   if PrinterSetupDialog.Execute() then
   begin
		Drukuj(Image1.Picture.Bitmap);
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
   fn : String;

begin
   fn := 'trawa.bmp';
   Image1.Picture.LoadFromFile(fn);
end;

procedure TMainForm.Drukuj(Bmp: TBitmap);
var
   x : Integer;
   y : Integer;

begin
	x := 0;
   y := 0;

	// drukujemy poziomo
	Printer.Orientation := poLandscape;

	// start drukowania
   Printer.BeginDoc();

	// dugo strony
   x := Printer.PageWidth;
	// wysoko strony
	y := Printer.PageHeight;

   Printer.Canvas.CopyRect(Rect(10, 10, x, y),
                           Bmp.Canvas,
                           Rect(0, 0, Bmp.Width, Bmp.Height));
	// koniec drukowania
	Printer.EndDoc();
end;

end.
